%% function to edit the MFs

function editMFs(action,hObject, eventdata, handles)
% hObject    handle to Button_Edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global MFsX MFsY1 minX maxX minY1 maxY1 MFsY2 minY2 maxY2
global selected thePoint theAxes

if nargin<1,
    action='initialize';
end;

Y1=minY1-[0 1 1 0]*(maxY1-minY1)/10;
squareY1=[-0.015 0.015 0.015 -0.015, -0.015]*(maxY1-minY1);
X1=minX-[0 1 1 0]*(maxX-minX)/10;
squareX1=[-0.015 0.015 0.015 -0.015, -0.015]*(maxX-minX);

Y2=minY2-[0 1 1 0]*(maxY2-minY2)/10;
squareY2=[-0.015 0.015 0.015 -0.015, -0.015]*(maxY2-minY2);
X2=X1;
squareX2=squareX1;

switch lower(action)

    case 'initialize'
        % Set all global flags to zero
        theAxes=0;
        thePoint=[0 0];

        %% plot a square for every turning point of MFsX
        axes(handles.axes1);
        [M,N]=size(MFsX);
        for i=1:M
            for j=1:N
                plot(MFsX(i,j)+[-.015 -.015 .015 .015 -.015]*(maxX-minX),Y1(j)+squareY1,'k','linewidth',1);
                hold on;
            end
        end
        [M,N]=size(MFsY1);
        for i=1:M
            for j=1:N
                plot(X1(j)+squareX1,MFsY1(i,j)+[-.015 -.015 .015 .015 -.015]*(maxY1-minY1), 'k','linewidth',1);
            end
        end

        axes(handles.axes2);
        [M,N]=size(MFsX);
        for i=1:M
            for j=1:N
                plot(MFsX(i,j)+[-.015 -.015 .015 .015 -.015]*(maxX-minX),Y2(j)+squareY2,'k','linewidth',1);
                hold on;
            end
        end
        [M,N]=size(MFsY2);
        for i=1:M
            for j=1:N
                plot(X2(j)+squareX2,MFsY2(i,j)+[-.015 -.015 .015 .015 -.015]*(maxY2-minY2), 'k','linewidth',1);
            end
        end

        %% Set functions for mouse button up and down.
        set(gcf,'WindowButtonDownFcn',...
            'editMFs(''mousedown'',gcbo,[],guidata(gcbo))');

        set(gcf,'WindowButtonUpFcn',...
            'editMFs(''mouseup'',gcbo,[],guidata(gcbo))');

    case 'mousedown'
        %% Have not chosen an axes and a point
        theAxes=0;
        thePoint=[0 0];

        %% Find the position of the click
        axes(handles.axes1);
        currPt=get(gca,'CurrentPoint');
        currPt=currPt(1,1:2);

        %% Find the axes where the mouse is pressed
        [M,N]=size(MFsX);
        for i=1:M
            for j=1:N
                if abs(currPt(1)-MFsX(i,j)) <.015*(maxX-minX) & abs(currPt(2)-Y1(j))<0.015*(maxY1-minY1)
                    theAxes=1;
                    thePoint=[i,j];
                    fill(MFsX(i,j)+[-.015 -.015 .015 .015 -.015]*(maxX-minX),Y1(j)+squareY1,'g');
                    axes(handles.axes2); %% also highlight the point in axes2
                    fill(MFsX(i,j)+[-.015 -.015 .015 .015 -.015]*(maxX-minX),Y2(j)+squareY2,'g');
                    break;
                end
            end
        end
        [M,N]=size(MFsY1);
        for i=1:M
            for j=1:N
                if abs(currPt(1)-X1(j)) <.015*(maxX-minX) & abs(currPt(2)-MFsY1(i,j))<0.015*(maxY1-minY1)
                    theAxes=2;
                    thePoint=[i,j];
                    fill(X1(j)+squareX1,MFsY1(i,j)+[-.015 -.015 .015 .015 -.015]*(maxY1-minY1),'g');
                    break;
                end
            end
        end

        axes(handles.axes2);
        currPt=get(gca,'CurrentPoint');
        currPt=currPt(1,1:2);
        [M,N]=size(MFsX);
        for i=1:M
            for j=1:N
                if abs(currPt(1)-MFsX(i,j)) <.015*(maxX-minX) & abs(currPt(2)-Y2(j))<0.015*(maxY2-minY2)
                    theAxes=3;
                    thePoint=[i,j];
                    fill(MFsX(i,j)+[-.015 -.015 .015 .015 -.015]*(maxX-minX),Y2(j)+squareY2,'g');
                    axes(handles.axes1);
                    fill(MFsX(i,j)+[-.015 -.015 .015 .015 -.015]*(maxX-minX),Y1(j)+squareY1,'g');
                    break;
                end
            end
        end
        [M,N]=size(MFsY2);
        for i=1:M
            for j=1:N
                if abs(currPt(1)-X2(j)) <.015*(maxX-minX) & abs(currPt(2)-MFsY2(i,j))<0.015*(maxY2-minY2)
                    theAxes=4;
                    thePoint=[i,j];
                    fill(X2(j)+squareX2,MFsY2(i,j)+[-.015 -.015 .015 .015 -.015]*(maxY2-minY2),'g');
                    break;
                end
            end
        end

        %% A point is selected
        if sum(thePoint)
            selected=1;
        else
            selected=0;
        end

    case 'mouseup'
        if selected
            switch theAxes
                case 1
                    axes(handles.axes1);
                    currPt=get(gca,'CurrentPoint');
                    currPt=currPt(1,1:2);
                    MFsX(thePoint(1),thePoint(2))=currPt(1);
                    MFsX(thePoint(1),:)=sort(MFsX(thePoint(1),:));
                case 2
                    axes(handles.axes1);
                    currPt=get(gca,'CurrentPoint');
                    currPt=currPt(1,1:2);
                    MFsY1(thePoint(1),thePoint(2))=currPt(2);
                    MFsY1(thePoint(1),:)=sort(MFsY1(thePoint(1),:));
                case 3
                    axes(handles.axes2);
                    currPt=get(gca,'CurrentPoint');
                    currPt=currPt(1,1:2);
                    MFsX(thePoint(1),thePoint(2))=currPt(1);
                    MFsX(thePoint(1),:)=sort(MFsX(thePoint(1),:));
                case 4
                    axes(handles.axes2);
                    currPt=get(gca,'CurrentPoint');
                    currPt=currPt(1,1:2);
                    MFsY2(thePoint(1),thePoint(2))=currPt(2);
                    MFsY2(thePoint(1),:)=sort(MFsY2(thePoint(1),:));
            end
        end

        %% Update the summarization results
        updateSummary;

        %% Set functions for mouse button up and down.
        set(gcf,'WindowButtonDownFcn','');
        set(gcf,'WindowButtonUpFcn', '');

        %% Set the global flags to zero
        selected=0;
        theAxes=0;
        thePoint=[0 0];
end

